/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.content.switches;

import com.railwayteam.railways.content.switches.TrackSwitch;
import com.railwayteam.railways.content.switches.TrackSwitchBlock;
import com.railwayteam.railways.content.switches.TrackSwitchBlockItem;
import com.railwayteam.railways.registry.CREdgePointTypes;
import com.railwayteam.railways.util.EntityUtils;
import com.simibubi.create.CreateClient;
import com.simibubi.create.content.trains.graph.TrackGraph;
import com.simibubi.create.content.trains.graph.TrackNode;
import com.simibubi.create.content.trains.graph.TrackNodeLocation;
import java.util.Map;
import java.util.Objects;
import net.createmod.catnip.outliner.Outliner;
import net.createmod.catnip.theme.Color;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3965;

public class TrackSwitchDebugVisualizer {
    public static void visualizeSwitchExits(TrackSwitch sw) {
        class_310 mc = class_310.method_1551();
        class_1297 camera = mc.field_1719;
        if (camera == null) {
            return;
        }
        class_243 offset = new class_243(0.0, 0.4, 0.0);
        float width = 0.0625f;
        TrackNodeLocation from = sw.getSwitchPoint();
        TrackNodeLocation activeExit = sw.getSwitchTarget();
        for (TrackNodeLocation to : sw.getExits()) {
            boolean active = to == activeExit;
            Outliner.getInstance().showLine((Object)to, from.getLocation().method_1019(offset), to.getLocation().method_1019(offset)).colored(active ? new Color(0, 203, 150) : new Color(255, 50, 150)).lineWidth(width);
        }
    }

    public static void visualizePotentialLocations() {
        boolean skipHints;
        class_310 mc = class_310.method_1551();
        class_1297 camera = mc.field_1719;
        if (camera == null) {
            return;
        }
        if (mc.field_1724 == null) {
            return;
        }
        boolean bl = skipHints = !EntityUtils.isHoldingItem((class_1657)mc.field_1724, item -> item instanceof TrackSwitchBlockItem);
        if (skipHints) {
            class_239 hitResult = mc.field_1765;
            if (!(hitResult instanceof class_3965)) {
                return;
            }
            class_3965 blockHitResult = (class_3965)hitResult;
            if (blockHitResult.method_17783() == class_239.class_240.field_1333) {
                return;
            }
            class_2338 pos = blockHitResult.method_17777();
            class_2680 state = mc.field_1724.field_6002.method_8320(pos);
            if (!(state.method_26204() instanceof TrackSwitchBlock)) {
                return;
            }
        }
        int range = 64;
        int rangeSqr = range * range;
        for (TrackGraph graph : CreateClient.RAILWAYS.trackNetworks.values()) {
            for (TrackNodeLocation tnl : graph.getNodes()) {
                TrackNode node;
                Map connections;
                int connectionCount;
                if (!Objects.equals(tnl.dimension, mc.field_1687.method_27983()) || tnl.getLocation().method_1025(camera.method_19538()) > (double)rangeSqr) continue;
                for (TrackSwitch sw : graph.getPoints(CREdgePointTypes.SWITCH)) {
                    TrackSwitchDebugVisualizer.visualizeSwitchExits(sw);
                }
                if (skipHints || (connectionCount = (connections = graph.getConnectionsFrom(node = graph.locateNode(tnl))).size()) <= 2 || connectionCount > 4) continue;
                class_243 basePos = node.getLocation().getLocation();
                class_243 averageOffset = class_243.field_1353;
                class_243[] offsets = new class_243[connectionCount];
                int i = 0;
                for (Map.Entry entry : connections.entrySet()) {
                    class_243 offset = ((TrackNode)entry.getKey()).getLocation().getLocation().method_1020(basePos).method_1029();
                    averageOffset = averageOffset.method_1019(offset);
                    offsets[i] = offset;
                    ++i;
                }
                class_243 farthestOffset = class_243.field_1353;
                double farthestDistance = 0.0;
                for (class_243 offset : offsets) {
                    double distance = averageOffset.method_1025(offset);
                    if (!(distance > farthestDistance)) continue;
                    farthestDistance = distance;
                    farthestOffset = offset;
                }
                class_2350 offsetDirection = class_2350.method_10142((double)farthestOffset.field_1352, (double)farthestOffset.field_1351, (double)farthestOffset.field_1350);
                Outliner.getInstance().showAABB((Object)node, class_238.method_30048((class_243)tnl.getLocation().method_1031(farthestOffset.field_1352 / 2.0, farthestOffset.field_1351 / 2.0, farthestOffset.field_1350 / 2.0).method_1031(0.0, 0.5, 0.0), (double)1.0, (double)1.0, (double)1.0)).colored(graph.color).lineWidth(0.0625f);
            }
        }
    }
}

